### 实验名称

美国高中生的社交数据案例分析

### **实验目的**

了解特征工程的基本含义

了解特征归一化方法

了解数据预处理等基本知识

### **实验背景**

假设我们有一个美国高中生的社交数据集，其中包含了关于学生之间的社交网络关系和相关信息。我们可以对这个数据集进行一些案例分析，以了解高中生之间的社交行为和网络。这些案例分析可以帮助我们更深入地了解美国高中生的社交行为，揭示他们之间的社交网络结构和特征。从中我们可以识别潜在的社交影响因素、了解社交圈子的形成和发展，以及发现影响学生社交活动的因素。

### **实验原理**

特征工程在机器学习中占有非常重要的作用，一般认为包括缺失值处理、数据的特征值化、数据特征选择、数据转换四个部分。当数据拿到手里后，我们首先需要查验数据是否有空缺值，对异常数据进行处理，这是缺失值处理。从现有数据中挑选或将现有数据进行变形，组合形成新特征，这个过程称为特征构建。特征抽取是指当特征维度比较高，通过映射或变化的方式，用低维空间样本来表示样本的过程。特征选择是从一组特征中挑选出一些最有效的特征，以达到降低维度和降低过拟合风险的目的。

### 实验环境

Ubuntu 18.04

Python 3.9

pandas 2.0.3

sklearn 3.7.2

numpy 1.25.2

### 建议课时

3课时

### 实验步骤

**一、开发准备**

**1.开发环境准备**

获取数据集

```markup
wget wget http://10.90.3.2/HUP/DataMining/2023/07/snsdata.csv

```

在Terminal输入以下命令，启动jupyter：

```markup
jupyter notebook

```

在打开的浏览器中新建python3文件:

![01-notebook.png](./pic/01-notebook.png)

**二、实验内容**

**1.代码包的导入**

```python
import pandas as pd
import numpy as np
from pandas import cut  #等距离散化
from pandas import qcut  #等频离散化
from sklearn.preprocessing import Binarizer  #二值化
from sklearn.impute import SimpleImputer  #缺失值处理
from sklearn.neighbors import LocalOutlierFactor #离群处理
from sklearn.preprocessing import StandardScaler #标准化Z-score
from sklearn.preprocessing import MinMaxScaler #标准化
from sklearn.preprocessing import RobustScaler #标准化-离群值
from sklearn.preprocessing import OneHotEncoder #特征编码
from sklearn.preprocessing import LabelEncoder   #特征编码
import matplotlib.pyplot as plt  #画图工具
import warnings 
warnings.filterwarnings("ignore")  #不显示warning

```

**2.加载数据集**

```python
data=pd.read_csv("/home/ubuntu/snsdata.csv")  #美国高中生的社交数据
data1=data.copy()  #备份不同方法的练习需要


```

3.探索性分析

```python
data.head()  #前5行
data.tail(8)  #后8行
data.sample(10) #随机取10行
data.info() 
# 有效值小于样本总数，有缺失。类型为object ，非数值需要编码。
data.describe()
# 显示数值类型列的统计特征（样本数、均值、标准差、最小、最大、分位数）。
# 非数值类型不显示。
data.gender.value_counts()
# 注：显示非数值型特征的取值以及各值的个数。（F：有22054个样本。M：有5222个样本）

```

输出为：

![1721723172614](pic/1721723172614.png)

![1721723204573](pic/1721723204573.png)

![1721723232558](pic/1721723232558.png)



**3.缺失值处理**

```python
# 特征有效样本数少或对结果的影响很小可以考虑
data_new=data.dropna(axis=1,thresh=len(data)*.9)   #删除特征（其样本数小于数据集样本总数的90%）
data_new=data.dropna()   #删除有缺失值的样本
# 填充
# 对数值型数据可以采用均值填充、非数值型数据可以采用众数填充
imp_mean=SimpleImputer(missing_values=np.nan,strategy="mean")  #实例化SimpleImputer对象，均值填充
data["age_imp"]=imp_mean.fit_transform(data[["age"]])  #拟合填充，结果保存在数据集的新列上
imp_mode=SimpleImputer(missing_values=np.nan,strategy="most_frequent")  ##实例化SimpleImputer对象，众数填充
data["gender_imp"]=imp_mode.fit_transform(data[["gender"]])  #拟合填充，结果保存在数据集的新列上
# 或data_new2=data.fillna(method="bfill")
data.isna(.sum())
```

输出为：

![1721723400823](pic/1721723400823.png)





**4.离群值检测**

```python
# 3σ方法检测
mean_=data.friends.mean()
std_=data.friends.std()
data_n3=data[data.friends<mean_+3*std_][data.friends>mean_-3*std_]  #保留3西格玛内的样本
# 箱线图
data[["age"]].plot(kind="box",figsize=(5,6))
data[["drunk","shopping"]].plot(kind="box",figsize=(5,6))
# plt.boxplot(data[["drunk","shopping"]])

```

![image-20240314113646646.png](./pic/image-20240314113646646.png)

![image-20240314113703109.png](./pic/image-20240314113703109.png)

**5.标准化**

```python
# Z分数标准化
from sklearn.preprocessing import StandardScaler   #Z分数标准化
scaler = StandardScaler(copy=True)
scaler.fit(data[["friends"]])
data["friends_Zstd"] = scaler.transform(data[["friends"]])
import seaborn as sns
sns.distplot(data["friends"])#未标准化的friends数量分布

```

![image-20240314123920131.png](./pic/image-20240314123920131.png)

标准化后friends数量分布

```python
sns.distplot(data["friends_Zstd"])#标准化后friends数量分布

```

![image-20240314123931643.png](./pic/image-20240314123931643.png)

或者

```python
data[["friends_Zstd"]].plot(kind="hist",bins=25,figsize=(25,5))

```

![image-20240314123951207.png](./pic/image-20240314123951207.png)

MinMaxScaler标准化

```python
# MinMaxScaler标准化
from sklearn.preprocessing import MinMaxScaler 
filtered_columns = ["friends"]
scaler = MinMaxScaler(copy=False)
scaler.fit(data[["friends"]])
data["friends_MM"]=scaler.transform(data[["friends"]])
data[["friends_MM"]] .plot(kind="hist",bins=25,figsize=(5,6))


```

![image-20240314124029839.png](./pic/image-20240314124029839.png)

RobustScaler标准化

```python
# RobustScaler标准化
from sklearn.preprocessing import RobustScaler
rob=RobustScaler(
with_centering=True, #如果为True，则在标准化之前将数据居中
with_scaling=True, #如果为True，则将数据缩放到分位数范围
quantile_range=(25.0, 75.0), #用于计算scale_的分位数范围
copy=True #如果为False，请尝试避免复制并改为直接替换
)
rob.fit(data[["friends"]])
data["rob"]=rob.transform(data[["friends"]])
data["rob"].plot(kind="hist",bins=25,figsize=(5,5))


```

![image-20240314124044667.png](./pic/image-20240314124044667.png)

**6.编码**

map操作

```python
data=data1.copy()
# map操作
data["gender"]=data.gender.map({"F":0,"M":1,np.nan:0})
# data["gender"]=data.gender.map({"F":0,"M":1})   #无缺失数据或已处理
data
```

输出为：

![1721722954562](pic/1721722954562.png)



LabelEncoder操作

```python
from sklearn.preprocessing import LabelEncoder
le = LabelEncoder()
data["gender_le"]=le.fit_transform(data["gender"]) #编码
print(le.classes_)

```

![image-20240314145321117.png](./pic/image-20240314145321117.png)

get\_dummy操作

```python
# get_dummy操作
df = pd.get_dummies(data, columns=['gender'])
df.head()

```

![image-20240314145346533.png](./pic/image-20240314145346533.png)

onehot操作

```python
# onehot操作
from sklearn.preprocessing import OneHotEncoder
OHE = OneHotEncoder(sparse=False)  #不压缩稀疏矩阵
data_gender=OHE.fit_transform(data[['gender']])  #对性别用OneHotEncoder进行编码
data_gender
```

![image-20240314145414792.png](./pic/image-20240314145414792.png)

**7.离散化**

二值化操作

```python
# 二值化操作
from sklearn.preprocessing import Binarizer
# 二值化，阈值设置为10，返回值为二值化后的数据
Bir = Binarizer(threshold=10)
data["friends_Binarized"] = Bir.fit_transform(data[["friends"]])
data[["friends_Binarized","friends"]].head()
# 等距离散化
# 等距离散化，各个类比依次命名Friends_Number_Label_0...
n=2
d1 = pd.cut(data["friends"], n, labels =["Friends_Number_Label_"+str(i) for i in range(n)])
# 等频离散化
n=2
d1 = pd.qcut(data["friends"], n, labels =["Friends_Number_Label_"+str(i) for i in range(n)])
d1

```

![image-20240314125351265.png](./pic/image-20240314125351265.png)

K-means离散化

```python
# K-means离散化
data_f = data[['friends']].copy().dropna()
n = 4
from sklearn.cluster import KMeans
kmodel = KMeans(n_clusters = n) #实例化
kmodel.fit(data_f) #fit模型
center_ = pd.DataFrame(kmodel.cluster_centers_).sort_values(0)  #输出聚类中心，并排序(按“0”特征升序)
l_ = center_.rolling(2).mean().iloc[1:] #移动平均求相邻两项中点，作为分界点
l_=[data_f.min()[0]] + list(l_[0]) + [data_f.max()[0]] 
#附加边界点
d2=pd.cut(data_f["friends"],l_,labels=['friends_0','friends_1','friends_2','friends_3'],include_lowest=True)
d2

```

![image-20240314125403107.png](./pic/image-20240314125403107.png)

### **实验总结**

从中我们可以识别潜在的社交影响因素、了解社交圈子的形成和发展，以及发现影响学生社交活动的因素。这些分析结果有助于学校和教育机构，为学生提供更好的社交支持和培养社交技能。在这个数据集中，使用了数据预处理的相关方法，比如数据缺失值处理、二值化处理、标准化等方法。